/*
             Warpview - a Java viewer for the Wright Brothers
                     interactive wing warping 

                     Version 1.0.0a   - 10 May 01

                         Written by Tom Benson
                       NASA Glenn Research Center

>                              NOTICE
>This software is in the Public Domain.  It may be freely copied and used in
>non-commercial products, assuming proper credit to the author is given.  IT
>MAY NOT BE RESOLD.  If you want to use the software for commercial
>products, contact the author.
>No copyright is claimed in the United States under Title 17, U. S. Code.
>This software is provided "as is" without any warranty of any kind, either
>express, implied, or statutory, including, but not limited to, any warranty
>that the software will conform to specifications, any implied warranties of
>merchantability, fitness for a particular purpose, and freedom from
>infringement, and any warranty that the documentation will conform to the
>program, or any warranty that the software will be error free.
>In no event shall NASA be liable for any damages, including, but not
>limited to direct, indirect, special or consequential damages, arising out
>of, resulting from, or in any way connected with this software, whether or
>not based on warranty, contract, tort or otherwise, whether or not injury
>was sustained by persons or property or otherwise, and whether or not loss
>was sustained from, or arose out of the results of, or use of, the software
>or services provided hereunder.

*/

import java.awt.*;
import java.lang.Math ;

public class Warpview extends java.applet.Applet {
 
   int counter,count2,inc,pick ;

   Dispnl dispnl ;
   Image offscreenImg ;
   Graphics offsGg ;
   Image[][] animg = new Image[10][5] ;

   public void init() {
     int i;

     for (i = 1; i <= 7; i++ ) {
       animg[i-1][0] = getImage(getCodeBase(),
               "mech" + i + ".gif") ;
       animg[i-1][1] = getImage(getCodeBase(),
               "lif" + i + ".gif") ;
       animg[i-1][2] = getImage(getCodeBase(),
               "ornt" + i + ".gif") ;
       animg[i-1][3] = getImage(getCodeBase(),
               "for" + i + ".gif") ;
     }

     offscreenImg = createImage(this.size().width,
                      this.size().height) ;
     offsGg = offscreenImg.getGraphics() ;

     setLayout(new GridLayout(1,1,5,5)) ;
 
     dispnl = new Dispnl(this) ;
 
     add(dispnl) ;
 
     pick = 0 ;
     counter = 3 ;
     inc = 0 ;
     dispnl.pic.start() ;
   }
 
 
  class Dispnl extends Panel {
     Warpview outerparent ;
     Pic pic ;
     Conpnl conpnl ;
     Picpnl picpnl ;

     Dispnl (Warpview target) {
        outerparent = target ;
        setLayout(new BorderLayout(5,5)) ;
 
        pic = new Pic() ;
        conpnl = new Conpnl() ;
        picpnl = new Picpnl() ;
 
        add("Center", pic) ;
        add("South", conpnl) ;
        add("East", picpnl) ;
     }
 
     class Conpnl extends Panel {
        Warpview outerparent ;
        Scrollbar s1 ;
 
        Conpnl () {
          int i1 ;
 
          setLayout(new GridLayout(1,3,5,5)) ;

          s1 = new Scrollbar(Scrollbar.HORIZONTAL,3,1,0,7);

          add(new Label("Left Tip Down", Label.RIGHT)) ;
          add(s1) ;
          add(new Label("Right Tip Down", Label.LEFT)) ;
        }
 
        public boolean handleEvent(Event evt) {
          if(evt.id == Event.ACTION_EVENT) {
              this.handleBar(evt) ;
              return true ;
          }
          if(evt.id == Event.SCROLL_ABSOLUTE) {
              this.handleBar(evt) ;
              return true ;
          }
          if(evt.id == Event.SCROLL_LINE_DOWN) {
              this.handleBar(evt) ;
              return true ;
          }
          if(evt.id == Event.SCROLL_LINE_UP) {
              this.handleBar(evt) ;
              return true ;
          }
             if(evt.id == Event.SCROLL_PAGE_DOWN) {
             this.handleBar(evt) ;
             return true ;
          }
          if(evt.id == Event.SCROLL_PAGE_UP) {
             this.handleBar(evt) ;
             return true ;
          }
          else return false ;
       }
 
       public void handleBar(Event evt) {
          int i1,i2 ;
          double v1,v2 ;
          float fl1,fl2 ;

          i1 = s1.getValue() ;

          counter = i1 ;
       }
     }  // end Conpnl

     class Picpnl extends Panel {
        Warpview outerparent ;
        Button bt1,bt2,bt3,bt4 ;
 
        Picpnl () {
 
          setLayout(new GridLayout(4,1,5,5)) ;

          bt1 = new Button("Mechanics") ;
          bt1.setBackground(Color.white) ;
          bt1.setForeground(Color.blue) ;
          bt2 = new Button("Lift Force") ;
          bt2.setBackground(Color.blue) ;
          bt2.setForeground(Color.white) ;
          bt3 = new Button("Attitude") ;
          bt3.setBackground(Color.blue) ;
          bt3.setForeground(Color.white) ;
          bt4 = new Button("Forces") ;
          bt4.setBackground(Color.blue) ;
          bt4.setForeground(Color.white) ;

          add(bt1) ;
          add(bt2) ;
          add(bt3) ;
          add(bt4) ;
       }
 
       public boolean action(Event evt, Object arg) {
          if(evt.target instanceof Button) {
             this.handleButton(arg) ;
              return true ;
          }
          else return false ;
       }
 
       public void handleButton(Object arg) {
          String label = (String)arg ;

          if (label.equals("Mechanics")) {
             pick = 0 ;
             bt1.setBackground(Color.white) ;
             bt1.setForeground(Color.blue) ;
             bt2.setBackground(Color.blue) ;
             bt2.setForeground(Color.white) ;
             bt3.setBackground(Color.blue) ;
             bt3.setForeground(Color.white) ;
             bt4.setBackground(Color.blue) ;
             bt4.setForeground(Color.white) ;
          }
          if (label.equals("Lift Force")) {
             pick = 1 ;
             bt1.setBackground(Color.blue) ;
             bt1.setForeground(Color.white) ;
             bt2.setBackground(Color.white) ;
             bt2.setForeground(Color.blue) ;
             bt3.setBackground(Color.blue) ;
             bt3.setForeground(Color.white) ;
             bt4.setBackground(Color.blue) ;
             bt4.setForeground(Color.white) ;
          }
          if (label.equals("Attitude")) {
             pick = 2 ;
             bt1.setBackground(Color.blue) ;
             bt1.setForeground(Color.white) ;
             bt2.setBackground(Color.blue) ;
             bt2.setForeground(Color.white) ;
             bt3.setBackground(Color.white) ;
             bt3.setForeground(Color.blue) ;
             bt4.setBackground(Color.blue) ;
             bt4.setForeground(Color.white) ;
          }
          if (label.equals("Forces")) {
             pick = 3 ;
             bt1.setBackground(Color.blue) ;
             bt1.setForeground(Color.white) ;
             bt2.setBackground(Color.blue) ;
             bt2.setForeground(Color.white) ;
             bt3.setBackground(Color.blue) ;
             bt3.setForeground(Color.white) ;
             bt4.setBackground(Color.white) ;
             bt4.setForeground(Color.blue) ;
          }
       }
     }  // end Picpnl

     class Pic extends Canvas
             implements Runnable{
        Warpview outerparent ;
        Thread runner ;
        Image displimg ;
   
        Pic () {
            setBackground(Color.white) ;
            runner = null ;
            displimg = getImage(getCodeBase(),"mech4.gif") ;
        }

        public void start() {
           if (runner == null) {
              runner = new Thread(this) ;
              runner.start() ;
           }
        }
   
        public void run() {
          while (true) {
              displimg = animg[counter][pick] ;
              try { Thread.sleep(100); }
              catch (InterruptedException e) {}
              pic.repaint() ;
              counter = counter + inc ;
              if (counter == 7) counter = 6 ;
              if (counter == -1) counter = 0 ;
          }
        }

        public void update(Graphics g) {
           pic.paint(g) ;
        }
   
        public void paint(Graphics g) {
    
            offsGg.drawImage(displimg,0,0,this) ;
            g.drawImage(offscreenImg,0,0,this) ;
        }
      }
   }
}
